﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using WCF_BusinessManagerAHOBPRTests;

namespace VeteransAffairs.Registries.BusinessAHOBPR.Tests
{
    [TestClass()]
    public class MilitaryOccupationInfoTests
    {
        [TestMethod()]
        public void MilitaryOccupationInfo_Throws_Exception_When_Given_OutOfRange_Value()
        {
            AssertException.Throws<ArgumentOutOfRangeException>(() => new MilitaryOccupationInfo(null, new DateTime(), "V"));
        }

        [TestMethod()]
        public void MilitaryOccupationInfo_Does_Not_Throw_Exception_When_Given_Correct_Value()
        {
            var cut = new MilitaryOccupationInfo(null, DateTime.Now, "s");
            Assert.AreEqual("s", cut.OccupationType);
        }
    }
}